// // // // // // // // // // // // //
//
//	GameStatus
//
//	erstellt 31.12.97 von Andreas Warnke
//	geändert 12.5.98 von Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include "Game.h"
#include <Handler.h>
#include "GameStatus.h"
#include "AsciiKette.h"
#include "ServerWelt.h"
#include "Spieler.h"
#include "Objekt.h"
#include "Definitions.h"



// // // // // // // // // // // // //
//
//	Konstruktor
//


Game :: Game ()
{
	//	Infos über das Spielfeld:
	DieWelt = NULL;
	
	//	Sieg schon gefeiert:
	VictoryAlreadyCelebrated = false;
	
	//	Pulserate:
	SetPulseRate( 500000 );
};


	
// // // // // // // // // // // // //
//
//	Destruktor
//

Game :: ~Game ()
{
	//	Infos über das Spielfeld:
	if ( DieWelt != NULL )
	{
		delete DieWelt;
		DieWelt = NULL;
	};
};



// // // // // // // // // // // // //
//
//	MessageReceived
//

void Game :: MessageReceived ( BMessage * inMessage )
{
	//	Message von einem Client?
	if ( inMessage -> what == Msg_InterApplicationMessage )
	{
		//	TimeOut?
		if ( GetStatus () != NULL )
			if ( GetStatus () -> Hurry () )
				//	ignore Message:
				return;
			
		if ( Equal ( inMessage -> FindString ( "Type" ), "login" ) )
			//	Login-Message
			ClientLogin ( inMessage );
		else
		if ( Equal ( inMessage -> FindString ( "Type" ), "turn" ) )
			//	Move-Message
			ClientMove ( inMessage );
		else
		{
			//	unbekannter Message-Typ
			BAlert * Hinweis = new BAlert (
				"Hinweis",
				"Server received Message\n"
				"of unknown type.",
				"Hmm..."
			);
			if ( Hinweis != NULL )
				Hinweis -> Go ( NULL );
		}				
	}
	else
		ServerApplication :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // //
//
//	Login
//

void Game :: ClientLogin ( BMessage * inMessage )
{
	//	Daten aus Message extrahieren:
	const char StringDummy = '\0';
	const char * ClientName = inMessage -> FindString ("ClientName");
	if ( ClientName == NULL )
		ClientName = &StringDummy;
	const char * ClientPassword = inMessage -> FindString ("Password");
	if ( ClientPassword == NULL )
		ClientPassword = &StringDummy;
	const char * ClientReadOnlyPassword = inMessage -> FindString ("ReadOnlyPassword");
	uint32 ClientVersion = inMessage -> FindInt32 ("Version");
	BMessenger TheReply = inMessage -> ReturnAddress();
	
	//	Karte erstellen:
	if ( DieWelt == NULL )
	{
		//	Kantenlänge bestimmen:
		int KantenLaenge = 8;
		if ( GetStatus() != NULL )
		{
			GetStatus () -> SetStatusLine ( "Status: Creating map." );
			KantenLaenge = GetStatus() -> GetSizeAndLock ();
		};
		//	Speicher reservieren:
	 	DieWelt = new ServerWelt ( KantenLaenge );
		if ( DieWelt == NULL )
		{
			//	Out of memory
			SendError ( 
				TheReply,
				ClientName,
				ClientPassword,
				eOutOfMemoryNotLoggedIn );
			return;
		}
		DieWelt -> InitMap ();
	};
 	
	//	Spieler mit identischem Namen suchen:
	Spieler * Match = DieWelt -> FindClient ( ClientName );
	
	if ( Match == NULL )	
	{
		//	Client mit Namen Client existiert noch nicht.
	
		//	Dürfen sich neue Spieler einloggen?
		if ( GetStatus () != NULL )
			if ( GetStatus() -> GetLoginSperre() == 1 )
			{
				SendError ( 
					TheReply,
					ClientName,
					ClientPassword,
					eServerRefusesLogin );
				return;
			};
			
		//	Neuen Client erstellen:
		Spieler * NewClient = new Spieler (
			ClientName,
			ClientPassword,
			ClientReadOnlyPassword,
			false,
			ClientVersion,
			DieWelt -> GetNextSpielerID(),
			TheReply
		);
					
		if ( NewClient != NULL )
		{			
			//	Spieler und Karte erstellt.
		
			//	Neuen Client in die Spielerliste aufnehmen:
			if ( ! DieWelt -> SpielerListe . Insert ( ( Element*) NewClient ) )
			{
				//	Spieler nicht in der Liste.
				
				//	Spieler löschen:
				delete NewClient;
				NewClient = NULL;
			};
		};

		if ( NewClient != NULL )
		{			
			//	Spieler und Karte erstellt, Spieler in Liste.
			
			//	Update der Status-Zeile:
			if ( GetStatus () != NULL )
			{
				char * sNewText;
				if ( NewClient -> DieID == 2 )
					sNewText = Concat ( "Status: Running. 1 player logged in.", NULL );
				else	
					sNewText = ConcatAndDeleteEven (
						"Status: Running. ",
						IntToString ( NewClient -> DieID - 1 ),
						" players logged in.");
				if ( sNewText != NULL )
				{
					GetStatus () -> SetStatusLine ( sNewText );
					delete [] sNewText;
				};
			};
		
			//	Willkommen:
			SendWelcome ( NewClient );	

			//	Startfigur für NewClient erstellen:
			if ( ! DieWelt -> NeuerSpieler ( NewClient -> DieID, 2, 1 ) )
			{
				//	Es gibt keinen Start-Platz.
				SendError (
					NewClient,
					eMapTooSmall );
			};
		}
		else
			//	Spieler existiert nicht.
			
			//	FehlerMeldung:
			SendError ( 
				TheReply,
				ClientName,
				ClientPassword,
				eOutOfMemoryNotLoggedIn );
	}
	else
	{
		//	Client mit Namen ClientName existiert schon.
	
		if ( Equal ( Match -> DasPasswort, ClientPassword ) ||
			Equal ( Match -> DasReadOnlyPasswort, ClientPassword ) )
		{
			//	Das Passwort stimmt.
		
			//	Erstellen eines weiteren Clients:
			Spieler * NewClient2 = new Spieler (
				ClientName,
				Match -> DasPasswort,
				Match -> DasReadOnlyPasswort,
				! Equal ( Match -> DasPasswort, ClientPassword ),
				ClientVersion,
				Match -> DieID,
				TheReply);
				
			if ( NewClient2 != NULL )
			{			
				//	Spieler und Karte erstellt.
			
				//	Neuen Client in die Spielerliste aufnehmen:
				if ( ! DieWelt -> SpielerListe . Insert ( (Element*) NewClient2 ) )
				{
					//	Spieler ist nicht in der Liste.
					
					//	Spieler löschen:
					delete NewClient2;
					NewClient2 = NULL;
				};
			};
				
			if ( NewClient2 != NULL )
			{			
				//	Spieler & Karte existieren, Spieler in Liste.
			
				//	Willkommen:
				SendWelcome ( NewClient2 );
					
				//	Status:
				DieWelt -> ReportEverything ( NewClient2 );
			}
			else
				//	Spieler existiert nicht.
			
				//	FehlerMessage:
				SendError ( 
					TheReply,
					ClientName,
					ClientPassword,
					eOutOfMemoryNotLoggedIn );
		}
		else
		{
			//	Falsches Passwort.

			//	FehlerMessage schicken:
			SendError (
				TheReply,
				ClientName,
				ClientPassword,
				eWrongPasswordNotLoggedIn );
		};		
	};
};


	
// // // // // // // // // // // // //
//
//	Move
//

void Game :: ClientMove ( BMessage * inMessage )
{
	//	Existiert die welt?
	if ( DieWelt == NULL )
		return;
		
	//	Suche Client in SpielerListe:
	Spieler * EinPassenderClient = DieWelt -> FindClient ( inMessage -> FindString ("ClientName") );
	
	//	Prüfe Passwort:
	if ( EinPassenderClient != NULL )
	if ( Equal ( EinPassenderClient -> DasPasswort, inMessage -> FindString ("Password") ) )
	{
		//	SpielerID bestimmen:
		unsigned int SpielerID = EinPassenderClient -> DieID;
		
		Objekt * MoveMe = DieWelt -> FindObject ( inMessage -> FindInt32 ( "ID" ) );
		if ( MoveMe != NULL )
		{
			//	passendes Objekt gefunden.
			if ( MoveMe -> BelongsTo == SpielerID )
				//	Der Spieler hat die nötigen Rechte.
				if ( Equal ( inMessage -> FindString ( "Action" ), "move" ) )
				{
					//	Action = move.
					MoveMe -> MoveToX = inMessage -> FindInt32 ( "MoveToX" );
					MoveMe -> MoveToY = inMessage -> FindInt32 ( "MoveToY" );
					DieWelt -> MakeMove ( MoveMe );
				}
				else if ( Equal ( inMessage -> FindString ( "Action" ), "build" ) )
					//	Action = build.
					if ( eEnableBuildingCities )
						DieWelt -> BuildVillage ( MoveMe );
		};
	};
};



// // // // // // // // // // // // //
//
//	SendError:
//

void Game :: SendError (
	Spieler * inAdressat,
	int inErrorCode)
{
	//	Parametercheck:
	if ( inAdressat == NULL )
		return;
	if ( ! inAdressat -> alive )
		return;
	
	if ( inAdressat -> readOnly )
		//	Client hat nur lese-Zugriff:
		SendError (
			inAdressat -> DerBote,
			inAdressat -> DerName,
			inAdressat -> DasReadOnlyPasswort,
			inErrorCode );
	else
		SendError (
			inAdressat -> DerBote,
			inAdressat -> DerName,
			inAdressat -> DasPasswort,
			inErrorCode );
};

void Game :: SendError (
	BMessenger inAdressat,
	const char * inClientName,
	const char * inClientPassword,
	int inErrorCode )
{
	//	Erstellen der Message:
	BMessage *dieNachricht = new BMessage ( Msg_InterApplicationMessage );
	if ( dieNachricht == NULL )
		return;
	dieNachricht -> AddString("Type","error");
	dieNachricht -> AddInt32("Version", 1);
	dieNachricht -> AddString("ClientName", inClientName);
	dieNachricht -> AddString("Password", inClientPassword);
	dieNachricht -> AddInt32("ErrorCode", inErrorCode);
	switch ( inErrorCode )
	{
	case eNoError:
		dieNachricht -> AddString("ErrorText", "No error occured.");
		break;
	case eServerRefusesLogin:
		dieNachricht -> AddString("ErrorText", "The server refuses the login request.");
		break;
	case eIncompatibleVersions:
		dieNachricht -> AddString("ErrorText", "Server and Client are incompatible.");
		break;
	case eMapTooSmall:
		dieNachricht -> AddString("ErrorText", "Map too small. Not logged in.");
		break;
	case eOutOfMemoryNotLoggedIn:
		dieNachricht -> AddString("ErrorText", "Server is out of memory. Not logged in.");
		break;
	case eWrongPasswordNotLoggedIn:
		dieNachricht -> AddString("ErrorText", "A Client with your name already exists. Wrong password.");
		break;
	default:
		dieNachricht -> AddString("ErrorText", "An error occured. Unknown errortype.");
	};
		
	//	Message verschicken:
	if ( inAdressat . IsValid() )
		inAdressat . SendMessage ( dieNachricht );
			
	//	Speicher freigeben:
	if ( dieNachricht != NULL )
		delete dieNachricht;
};



// // // // // // // // // // // // //
//
//	SendWelcome:
//

void Game :: SendWelcome ( Spieler * inAdressat )
{
	if (( DieWelt == NULL ) || ( inAdressat == NULL ))
		return;
	if ( ! inAdressat -> alive )
		return;
		
	//	Erstellen der Message:
	BMessage dieNachricht ( Msg_InterApplicationMessage );
	dieNachricht . AddString("Type","welcome");
	dieNachricht . AddInt32("Version", 1);
	dieNachricht . AddString("ClientName", inAdressat -> DerName );
	if ( inAdressat -> readOnly )
		dieNachricht . AddString("Password", inAdressat -> DasReadOnlyPasswort );
	else
		dieNachricht . AddString("Password", inAdressat -> DasPasswort );
	dieNachricht . AddInt32("ClientID", inAdressat -> DieID );
	dieNachricht . AddInt32("MapSize", DieWelt -> GetWidth() );
		
	//	Message verschicken:
	if ( inAdressat -> DerBote . IsValid() )
		inAdressat -> DerBote . SendMessage ( & dieNachricht );
	else
		inAdressat -> alive = false;
};



// // // // // // // // // // // // //
//
//	Pulse:
//

void Game :: Pulse ()
{
	//	CheckBusyList:
	if ( DieWelt != NULL )
	{
		DieWelt -> CheckBusyList ();
		if ( ( DieWelt -> GetWinner () != 0 ) && ( ! VictoryAlreadyCelebrated ) )
			CelebrateVictory ( DieWelt -> GetWinner () );
	};
};



// // // // // // // // // // // // //
//
//	CelebrateVictory:
//

void Game :: CelebrateVictory ( unsigned int inID )
{
	//	Zeige Gewinner in der statuszeile an:
	if ( ( GetStatus () != NULL ) && ( DieWelt != NULL ) )
	{
		GetStatus () -> SetAndDisableLoginSperre ();
		char * sTheText = Concat (
			"Status: Victory! The winner is ",
			DieWelt -> SpielerName ( inID ),
			"." );
		if ( sTheText != NULL )
		{
			GetStatus () -> SetStatusLine ( sTheText );
			delete [] sTheText;
		};
	};
	
	//	Schicke Victory-Message:
	if ( DieWelt != NULL )
		DieWelt -> ReportVictory (
			inID,
			DieWelt -> SpielerName ( inID ) );
	
	VictoryAlreadyCelebrated = true;
};



//
//	Ende
//
// // // // // // // // // // // // //